<?php 
	function getMarathonType(){
		global $DB;
		$gender = "";
		$status = "0";
		$msg = "Error, no data found";
		$sql = "SELECT tournamentName,isPaid FROM `".$DB->pre."tournament` WHERE status = 1";
		$D = $DB->dbRows($sql);
		if (count($D) > 0) {
			$status = "1";
			$msg = "Success";
		}	
		else{
			$status = "0";
			$msg = "Error, no data found";	
		}
		
		$data = $D;
		return json_encode(array("data"=>$data,"status"=>$status,"msg"=>$msg));
	}

	function getGallery(){
		global $DB;
		$photoath = "";
		$sql = "SELECT galleryTitle,galleryImage FROM `".$DB->pre."gallery` WHERE status = 1";
		$D = $DB->dbRows($sql);
		foreach ($D as $key => $val) {
			$D[$key]['galleryImage'] = SITEURL.'/uploads/gallery/'.$val["galleryImage"];
		}
		$status = "0"; 
		$msg = "Error, no data found";
		if (count($D) > 0) {
			$status = "1";
			$msg = "Success";
		}
		$data =$D;
		return json_encode(array("data"=>$data,"status"=>$status,"msg"=>$msg));
	}

	function getTournamentPrizes(){
		global $DB;
		$tid = "";
		$status = "0";
		$msg = "Error, no data found";
		$sql = "SELECT tournamentID,tournamentName,distance,feeAmount FROM `".$DB->pre."tournament` WHERE status = 1";
		$T = $DB->dbRows($sql);
		if (count($T) > 0) {
			$status = "1";
			$msg = "Success";
			foreach ($T as $key => $val) {
				$res = getPrizes($val['tournamentID']);
				$T[$key]['totalPrizeAmount'] = $res['total'];
				$T[$key]['prizes'] = $res['data'];
			}
		}
		return json_encode(array("data"=>$T,"status"=>$status,"msg"=>$msg));
	}

	function getPrizes($tid = 0){
		global $DB;
		$total = 0;
		$sql = "SELECT prizeID,prizeTitle,prizeAmount FROM `".$DB->pre."prize` WHERE status = 1 AND 
			tournamentID = ".$tid." ORDER BY orderNo ASC";
		$P = $DB->dbRows($sql);
		foreach ($P as $p) {
			$total += preg_replace('/[^A-Za-z0-9\']/', '', $p["prizeAmount"]);
		}
		$D = array("total"=>$total,"data"=>$P);
		return $D;
	}

	function getSchoolCollegeList(){
		global $DB;
		$val = "";
		$status = "0";
		$msg = "No data found";
		$sql = "SELECT branchID,CONCAT(collegeSchoolName,' ',cityVillage,' ',taluka) AS collegeSchoolName,cityVillage,taluka FROM `".$DB->pre."branch_list` WHERE status = 1";
		$D = $DB->dbRows($sql);
		if (count($D) > 0) {
			$status = "1";
			$msg = "Success";
		}	
		$data = $D;
		return json_encode(array("data"=>$data,"status"=>$status,"msg"=>$msg));
	}

	function getTournament(){
		global $DB;
		$status = "0";
		$msg = "No data found";
		$sql = "SELECT tournamentID,tournamentName,maleFemale,distance,isPaid,feeAmount,minAge,maxAge FROM `".$DB->pre."tournament` WHERE status = 1";
		$D = $DB->dbRows($sql);
		$data = array();
		if (count($D) > 0) {
			foreach($D AS $k=>$d){
				if($d['maxAge'] == 0 && $d['minAge'] != 0){
			        $d['maxAge'] = 'Above '.$d['minAge'];
			    }
				$data[$k] = $d;
			}
			$status = "1";
			$msg = "Success";
		}
		return json_encode(array("data"=>$data,"status"=>$status,"msg"=>$msg));
	}

	function getSponsership(){
		global $DB;
		$sql = "SELECT sponsershipTitle,sponsershipImg FROM `".$DB->pre."sponsership` WHERE status = 1";
		$D = $DB->dbRows($sql);
		foreach ($D as $key => $val) {
			$D[$key]['sponsershipImg'] = SITEURL."/uploads/sponsership/".$val["sponsershipImg"];
		}
		$status = "0"; 
		$msg = "Error, no data found";
		if (count($D) > 0) {
			$status = "1";
			$msg = "Success";
		}
		$data = $D;
		return json_encode(array("data"=>$data,"status"=>$status,"msg"=>$msg));
	}

	function getRulesRegulations(){
		global $DB;
		$status = "0";
		$msg = "Error,No Data Found";
		$sql = "SELECT pageTitle,pageContent FROM `".$DB->pre."page` WHERE pageID = 2 AND status = 1";
		$D = $DB->dbRow($sql);
		if (count($D) > 0) {
			$status = "1";
			$msg = "Success";
		}
		return json_encode(array("data"=>$D,"status"=>$status,"msg"=>$msg));
	}

	function checkDublicateUser(){
		require("../inc/common.inc.php");
		$mobileNo = $_REQUEST['mobileNo'];
		$D = array();
		if($mobileNo>0){
			$status = checkDublicate("",$mobileNo,"","");
			$msg = "Mobile no already registered";
			if($status){
				$msg = "Mobile no. not registered";
			}
		}
		return json_encode(array("data"=>$D,"status"=>$status,"msg"=>$msg));
	}

	function registerUser(){
		global $DB,$PAIDMARATHONS,$OPENMARATHONS;
		require_once(ABSPATH.'/inc/common.inc.php');
		require_once(ABSPATH.'/payment/inc/payment.inc.php');
		$msg = "Sorry, registration is over.";
		$status = false;
		$isRegistrationOver = true;
		$D = array();
		if($_POST['tournamentID']>0 && !$isRegistrationOver){
			$mobileNo = $_REQUEST['mobileNo'];
			$dubStatus = checkDublicate("",$mobileNo,"","");
			if(!$dubStatus){
				$msg = "Mobile no. already registered";
			}else{
				$bibNo = getBibNo($_POST['branchID'],$_POST['tournamentID'],$_POST['isMvpStudent']);
				$msg = "Registration is full";
				if($bibNo!="FULL"){
					$_POST['doctorCertificate'] = uploadFile("doctorCertificate",$_FILES['doctorCertificate']['name'],"uploads/participants/");
					$_POST['userImage'] = uploadFile("userImage",$_FILES['userImage']['name'],"uploads/participants/");
					$_POST['bibNo'] = $bibNo;
					$msg = "Error in data inserting";
					$pre = "";
					if(insertUserData($_POST)){
						if($_POST['isMvpStudent']=="2" && !in_array($_POST['tournamentID'],$OPENMARATHONS)){
							$pre = "N";
						}
						$D['bibNo'] = $pre.$bibNo;
						$msg = "Registration Successful!!! Your BIB number is ".$D['bibNo']." Please collect your BIB number & kit before 4 th January 2018  from MVP central office. Please do not delete this massage.";
						$status = true;
					}
				}
			}	
		}
		return json_encode(array("data"=>$D,"status"=>$status,"msg"=>$msg));
	}

	function checkRegistrationStatus($branchID="",$tournamentID="",$isMvpStudent=""){
		global $DB;
		require_once(ABSPATH.'/inc/common.inc.php');
		$status = true;
		$D = array();
		$msg = "Registration not full";
	    $bibNo = getBibNo($branchID,$tournamentID,$isMvpStudent);
		if($bibNo=="FULL"){
			$status = false;
			$msg = "Registration full";
		}
		return json_encode(array("data"=>$D,"status"=>$status,"msg"=>$msg));
	}

	function logRequest(){
	 $req_dump = print_r($_REQUEST, TRUE);
	 $file_dump = print_r($_FILES, TRUE);
	 file_put_contents("log.txt", $req_dump, FILE_APPEND);
	 file_put_contents("log.txt", $file_dump, FILE_APPEND);
	}

	if(trim($_REQUEST["xAction"])) {
		logRequest();
		require("../connectdb.inc.php");
		//require("../inc/site.inc.php");	
		switch(trim($_REQUEST["xAction"])) {
			case 'getMarathonType':       
				echo getMarathonType();
			break;
			case 'getGallery':
				echo getGallery();		
			break;
			case 'getTournamentPrizes':
				echo getTournamentPrizes();		
			break;
			case 'getSchoolCollegeList':
				echo getSchoolCollegeList();		
			break;
			case 'getTournament':
				echo getTournament();		
			break;
			case 'getSponsership':
				echo getSponsership();		
			break;
			case 'getRulesRegulations':
				echo getRulesRegulations();		
			break;
			case "checkDublicateUser":
				echo checkDublicateUser();
			break;
			case 'registerUser':
				echo registerUser();
			break;
			case "checkRegistrationStatus":
                echo checkRegistrationStatus($_REQUEST['branchID'],$_REQUEST['tournamentID'],$_REQUEST['isMvpStudent']);
			break;	
		}
	}
	?>
