<?php
function setLangs(){
	global $MXSETTINGS,$MXLANGS;
	if($MXSETTINGS["lang"]){
		$strL = ""; global $DB;		
		$sql = "SELECT * FROM `".$DB->pre."admin_language` WHERE status='1' ORDER BY langName ASC";
		$DB->dbRows($sql);	
		if($DB->numRows > 0) { $MXLANGS = $DB->rows; }
	}
}

function mxGetMetaArray($metaKey="",$metaValue=0,$metaType=0){
	$arr = array();
	if($metaKey){
		global $DB;
		$sql = "SELECT * FROM `".$DB->pre."admin_meta` WHERE `metaKey` = '$metaKey' AND `metaValue`='$metaValue' AND metaType='$metaType'";
		$arr = $DB->dbRow($sql);
	}
	return $arr;
}

function mxGetMeta(){
	global $TPL;
	if($TPL->metaTitle)
		$str  = "\n".'<title>'.mx_strip_all_tags($TPL->metaTitle).'</title>';
	if($TPL->metaDesc)
		$str .= "\n".'<meta name="description" content="'.mx_strip_all_tags(limitChars($TPL->metaDesc,160,''),true).'" />';
	if($TPL->metaKeyword)
		$str .= "\n".'<meta name="keywords" content="'.mx_strip_all_tags(limitChars($TPL->metaKeyword,160,''),true).'" />';
	return $str;
}

function createMenu($menuID=0,$depth=100,$level=0){
	global $TPL,$DB;
	if($menuID){
		$sql  ="SELECT * FROM ".$DB->pre."menu WHERE status='1' AND parentID = '$menuID' ORDER BY xOrder ASC";
		$DB->dbRows($sql);
		if($DB->numRows){						
			if($level)
				$str .= '<ul class="tree-list">';
				foreach($DB->rows as $v) {
					$class = ''; $target = ''; $url = '';			
					if($v["seoUri"])
						if(strpos($TPL->pageUri,$v["seoUri"]) !== false) { $class = ' class="active"'; }	
					if($v["menuType"] == 'exlink') { 
						$url =  $v["seoUri"]; $target = ' target="_blank"';
					} else if($v["menuType"] == 'page') { 
						$url = SITEURL."/".$v["seoUri"]."/"; 
					} else { $url = SITEURL.$v["seoUri"]."/"; }
					
					$str .= '<li class="'.$v["menuClass"].'"><a'.$class.' href="'.$url.'"'.$target.'>' . $v["menuTitle"] . '</a>';
					$str .= createMenu($v["menuID"],$depth,$level+1); $level-1;
					$str .= '</li>';
				}
				if($level)
					$str .= '</ul>';				
			}
	}
	return $str;
}

function getMenu($menuTitle="",$depth=100){
	global $DB; $str = "";
	if($menuTitle){ 
		$sql = "SELECT menuID FROM ".$DB->pre."menu WHERE status='1' AND menuTitle = '$menuTitle'";
		$d = $DB->dbRow($sql);
		if($DB->numRows){
			$str = createMenu($d["menuID"],$depth);
		}
	}
	return $str;
}

function getPostCatId($postID="") {
	global $DB;	
	$sql = "SELECT categoryID  FROM ".$DB->pre."post_category WHERE postID= '$postID'";	
	$DB->dbRows($sql);
	$arrCat = array();
	
	if($DB->numRows > 0){
		foreach($DB->rows as $cat){
			$arrCat[] = $cat['categoryID'];
		}		
	}
	return $arrCat;
}

function getCatTree($parentID=0,$type="checkbox",$arrCurr=array(),$skipCats = array(),$maxLevel=100,$level=0,$strUri="",$strMenu = ""){	
	global $DB;	
	$removeCats = "";
	
	if($skipCats){
		$removeCats = " AND categoryID NOT IN ('".implode("', '",$skipCats)."')";
	}

	if(($level+1)<= $maxLevel){			
		$sql = "SELECT * FROM ".$DB->pre."category WHERE status = 1 AND parentID='".$parentID."' ".$removeCats." ORDER BY categoryID ASC";	
		$DB->dbRows($sql);		
		if($DB->numRows > 0) {
			if($level > 0 && $type != "")
				$strMenu.="<ul class='level-".($level-1)."'>";
				
			foreach($DB->rows as $ct){						
				$curr = "";											
				if(!$arrCurr) 
					$arrCurr = array();
					
				if($type == "checkbox") {
					if(in_array($ct['categoryID'],$arrCurr))
						$curr = ' checked="checked"';
						
					$strMenu.= '<li><input type="checkbox" id="categoryID'.$ct['categoryID'].'" name="categoryID[]" value="'.$ct['categoryID'].'" '.$curr.' class="checkbox" /> '.$ct['categoryTitle'];	
				} else if($type == "radio") {
					if(in_array($ct['categoryID'],$arrCurr))
						$curr = ' checked="checked"';
					$strMenu.= '<li><input type="radio" id="categoryID'.$ct['categoryID'].'" name="categoryID" value="'.$ct['categoryID'].'" '.$curr.' class="radio" /> '.$ct['categoryTitle'];	
				} else if($type == "treelist") {
					$newUri = $strUri."/".$ct['seoUri'];
					if(in_array($ct['categoryID'],$arrCurr)){
						$curr = ' class="active"';}
					$strMenu.="<li$curr><a $curr href='".SITEURL.$ct['seoUri']."/' rel='".$ct['categoryID']."'>".$ct['categoryTitle']."</a>";
				} else {				
					if(in_array($ct['categoryID'],$arrCurr))
						$curr = ' selected="selected"';
					$strMenu.= "<option value='".$ct['categoryID']."'$curr>".str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',$level).$ct['categoryTitle']."</option>";
				}
						
				$strMenu = getCatTree($ct["categoryID"],$type,$arrCurr,$skipCats,$maxLevel,$level+1,$newUri,$strMenu);
				$level-1;
				
			}
			if($level > 0 && $type != "")
				$strMenu.="</ul></li>";	
				
		} else {		
			if($type != "")
				$strMenu.="</li>"; $strUri = "";
		}	
	}
	if($strMenu) 
		return $strMenu;
}

function queryString($params, $name=null) {
	$ret = "";
	foreach($params as $key=>$val) {
		if(is_array($val)) {
			if($name==null) $ret .= queryString($val, $key);
			else $ret .= queryString($val, $name."[$key]");   
		} else {
			if($name!=null)
				$ret.=$name."[$key]"."=$val&";
			else $ret.= "$key=$val&";
		}
	}
	return $ret;   
}

function getCatParents($categoryID=0,$arrCats=array()){
	if($categoryID){
		global $DB;
		$sql  ="SELECT parentID FROM ".$DB->pre."category WHERE categoryID='".$categoryID."' AND parentID!='0'";	
		//echo "<br>".$sql;
		$DB->dbRow($sql);		
		if($DB->numRows > 0) {						
			$arrCats[] = $DB->row["parentID"];
			$arrCats = getCatParents($DB->row["parentID"],$arrCats);			
		}
	}	
	return $arrCats;
}

function getCategoryMenu($parentID,$categoryID){
		global $DB;
		$sql  ="SELECT * FROM ".$DB->pre."category WHERE parentID='".$parentID."' ORDER BY categoryID ASC";
		$DB->dbRows($sql);
		if($DB->numRows > 0) {
			foreach($DB->rows as $ct){
				$curr = '';
				if($ct['categoryID']==$categoryID){
					$curr = ' class="active"';
				}
				$strMenu.="<li$curr><a $curr href='".SITEURL.$ct['seoUri']."/' rel='".$ct['categoryID']."' id='".makeSeoUri($ct['categoryTitle'])."'>".$ct['categoryTitle']."</a></li>";
			}
		}
	return $strMenu;
}

function getCatUrl($categoryID=0){
	$str = "";
	if($categoryID){
		global $DB;
		$sql  ="SELECT seoUri FROM ".$DB->pre."category WHERE categoryID='".$categoryID."'";	
		//echo "<br>".$sql;
		$DB->dbRow($sql);		
		if($DB->numRows > 0) {						
			$str = SITEURL.$DB->row["seoUri"]."/";					
		}
	}	
	return $str;
}

function getPostUrl($postArr = array()){
	global $POSTURL;
	$str = '';
	if(!empty($postArr)) {
		if(count($POSTURL) == 3){
			$str = SITEURL.'/'.date("Y/m/d",strtotime($postArr['datePublish'])).'/'.$postArr['seoUri'].'/'.$postArr['postID'].'/';
		}elseif(count($POSTURL) == 2) {
			$str = SITEURL.'/'.$postArr['seoUri'].'/'.$postArr['postID'].'/';
		}elseif(count($POSTURL) == 1) {
			$str = SITEURL.'/'.$postArr['seoUri'].'/';
		}
	}
	return $str;
}

// ------------------------------------------------------------------------------

function parse_youtube_url($url,$return='embed',$width='',$height='',$rel=0){
    $urls = parse_url($url);
   
    //url is http://youtu.be/xxxx
    if($urls['host'] == 'youtu.be'){
        $id = ltrim($urls['path'],'/');
    }
    //url is http://www.youtube.com/embed/xxxx
    else if(strpos($urls['path'],'embed') == 1){
        $id = end(explode('/',$urls['path']));
    }
     //url is xxxx only
    else if(strpos($url,'/')===false){
        $id = $url;
    }
    //http://www.youtube.com/watch?feature=player_embedded&v=m-t4pcO99gI
    //url is http://www.youtube.com/watch?v=xxxx
    else{
        parse_str($urls['query']);
        $id = $v;
        if(!empty($feature)){
            $id = end(explode('v=',$urls['query']));
        }
    }
    //return embed iframe
    if($return == 'embed'){
        return '<iframe width="'.($width?$width:560).'" height="'.($height?$height:349).'" src="http://www.youtube.com/embed/'.$id.'?rel='.$rel.'&autoplay=0&autohide=1&wmode=transparent" frameborder="0" allowfullscreen></iframe>';
    }
    //return normal thumb
    else if($return == 'thumb'){
        return 'http://i1.ytimg.com/vi/'.$id.'/default.jpg' ;
    }
    //return hqthumb
    else if($return == 'hqthumb'){
        return 'http://i1.ytimg.com/vi/'.$id.'/hqdefault.jpg';
    }
    // else return id
    else{
        return $id;
    }
}

function sendSMS($to,$sms){
	//$url = "http://54.254.154.166/sendhttp.php?user=marathavidya&password=123456&mobiles=#mobile&message=#sms&sender=MVPNSK";
	$url = "http://103.225.76.43/blank/sms/user/urlsms.php?username=nndmvpnashik&pass=ajitpatil@1091&senderid=MVPNSK&dest_mobileno=#mobile&message=#sms&response=Y";
	$url = str_replace('#mobile',$to, $url);
	$url = str_replace('#sms',urlencode($sms), $url);	
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$result = curl_exec($ch);
	curl_close($ch);
	return $result;
}

function getTournamentList(){
	global $DB; $data = array();
	$sql = "SELECT * FROM ".$DB->pre."tournament WHERE status=1 ORDER BY tournamentID ASC";
	$DB->dbRows($sql);
	if($DB->rows>0){
		foreach($DB->rows as $d){
			$data[$d['tournamentID']] = $d['tournamentName'];
		}	
	}
	return $data;
}

function getBranchBibNo($branchID=0){
	global $DB; $data = array();
	$sql = "SELECT bibFrom1,bibTo1,bibFrom2,bibTo2,bibFrom3,bibTo3,bibFrom4,bibTo4,bibFrom5,bibTo5,bibFrom6,bibTo6,bibFrom7,bibTo7,bibFrom8,bibTo8 
			FROM ".$DB->pre."branch_list
			WHERE status=1 AND branchID='$branchID'";
	$DB->dbRow($sql);
	if($DB->numRows>0){
		$data = $DB->row;
	}
	return $data;
}

function getMaxBibNo($where="1"){
	global $DB;
	$maxNo = 0;
	$sql = "SELECT MAX(bibNo) AS mxBib 
			FROM `".$DB->pre."participants` 
			WHERE $where ORDER BY dateAdded DESC LIMIT 1";
	$DB->dbRow($sql);		
	if($DB->numRows>0){
		$maxNo = $DB->row['mxBib'];
	}
	return intval($maxNo);
}

function setDefaultBib(){
	global $DB;
	$bibNo = 0;
	$whr = "status = 1";
	$maxBib = getMaxBibNo($whr);
	//echo 'maxBib=='.$maxBib;die;
	if($maxBib>=15000){
		$bibNo = $maxBib+1;		
	}else{
		$bibNo = 15000;
	}
	return $bibNo;
}

function getFieldArray(){
	global $FIELDARRAY;
	$tField = array();
	$tData = getTournamentList();
	if(count($tData)>0){
		$i = 0;
		foreach ($tData as $key => $value) {
			if($i<8){
				$tField[$key] = $FIELDARRAY[$i];
			}
			$i++;
		}
	}
	return $tField;
}
/*
function sendEmail($data=array()){
	$str = "ERR";
	$message = '<table width="600" style="margin:auto;">
	<tbody>
			<tr>
			  <td><div style="width:580px; padding:10px;font-family:Arial, Helvetica, sans-serif; font-size:13px; color:#414041;"> <img style="padding:25px; display:block;" src="' . SITEURL . '/images/logo.png">
				  <p>Hello <span>'.$data['firstName'].' '.$data['lastName'].'</span>,</p>
				  <p>You have successfully register in marathon.Your BIB number is '.$data['bibNo'].'</p>
				  <p>Please collect your BIB number before 1 st January 2016 from MVP central office ,K.T.H.M COLLEGE CAMPUS.
</p>
				  <div style="border:0; border-top:1px solid #e6e7e2; color:#404041;padding:7px 0 0;"> <strong><a href="' . SITEURL . '" style="text-decoration:none; font-size:13px; color:#404041;">http://nashikmvpmarathon.org/</a></strong> </div>
				</div></td>
			</tr>
		  </tbody>
		</table>';

	$subject = 'MVP Marathon 2016';
	$headers  = 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
	$headers .= 'From: MVP\'s Nashik Marathon <ajit@nashikmvpmarathon.org>' . "\r\n";
	//echo "message===".$message;die;
	if($data['emailID']){
		if(@mail($data['emailID'], $subject, $message, $headers)){
		  	$str = "OK";
		}
	}
	return $str;
}*/

function sendEmail($data = array())
{
	$str = "ERR";	
	$message = '<table width="600" style="margin:auto;">
	<tbody>
			<tr>
			  <td><div style="width:580px; padding:10px;font-family:Arial, Helvetica, sans-serif; font-size:13px; color:#414041;"> <img style="padding:25px; display:block;" src="' . SITEURL . '/images/logo.png">
				  <p>Hello <span>'.$data['firstName'].' '.$data['lastName'].'</span>,</p>
				  <p>You have successfully registered in MVPS Marathon.Your BIB number is <strong>'.$data['bibNo'].'</strong></p>
				  <p>Please collect your BIB number before 4<sup>th</sup> January 2019 from MVP central office ,K.T.H.M COLLEGE CAMPUS.</p>
                  <p><strong>Please do not delete this mail.</strong></p>
				  <div style="border:0; border-top:1px solid #e6e7e2; color:#404041;padding:7px 0 0;"> <strong><a href="' . SITEURL . '" style="text-decoration:none; font-size:13px; color:#404041;">http://nashikmvpmarathon.org/</a></strong> </div>
				</div></td>
			</tr>
		  </tbody>
		</table>';
		require(ABSPATH."/lib/class.phpmailer.inc.php");
		$mail = new PHPMailer();	
		$mail->IsSMTP();
		$mail->Host = "smtp.gmail.com";
//----------------New code---start---------------		
$mail->SMTPAuth = true;
$mail->Username = 'help@mvp.edu.in';//---less secure
$mail->Password = 'help@mvp';
$mail->IsHTML(true);
$body = eregi_replace("[\]",'',$message);
$mail->SMTPSecure = 'tls';
$mail->Port = 587;
$mail->setFrom('help@mvp.edu.in', 'MVP Samaj ,Nashik');
$mail->addAddress($data['emailID']);// Add a recipient
$mail->addCC('marathon@mvp.edu.in');// Add cc 
$mail->Subject = 'MVPS Marathon 2019';// Email subject
$mail->isHTML(true);// Set email format to HTML
$mail->MsgHTML($message);
$mail->ContentType = "text/html";
if($mail->Send())
{
			$str = "OK";
}
else
{
     echo 'Message could not be sent.';
    echo 'Mailer Error: ' . $mail->ErrorInfo;
}

/*//----------------old code---start---------------
		$mail->Port = 465;
		$mail->SMTPAuth = true;
		$mail->SMTPSecure = 'ssl';
		$mail->Username = "help@mvp.edu.in";
		$mail->Password = "help@mvp";
		$mail->IsHTML(true);

		$body = eregi_replace("[\]",'',$message);
		$mail->SetFrom("help@mvp.edu.in", "MVP Nashik");
		$mail->AddAddress($data['emailID'],'MVP Nashik');
		//$mail->AddBCC('javed@astrosports.in','Astro');
		$mail->Subject = "MVP Marathon 2019";
		$mail->MsgHTML($message);
		$mail->ContentType = "text/html";
		if($mail->Send()){
			$str = "OK";
		}
	return $str;
	//----------------old code---start-------------------*/		
}//SEND_EMAIL ENDS

function getBibNo($branchID=0,$tournamentID=0,$isMvpStudent=1){

	global $DB,$BIBARRAY,$SUBBIBARRAY,$OPENMARATHONS;
	$bibNo = 0;
	$where = "";
	//Where tournament type
	if(in_array($tournamentID, $OPENMARATHONS)){
		//Set bib number for open marathon
		$BIBARRAY[$tournamentID]['to'];
		$whr = "tournamentID = '".$tournamentID."' AND status=1";
		$maxBib = getMaxBibNo($whr);
		if($BIBARRAY[$tournamentID]['to']>$maxBib){
			$bibNo = $maxBib==0?$BIBARRAY[$tournamentID]['from']:$maxBib+1;
		}else{
			$bibNo = setDefaultBib();
		}
	}else{
	
		//Set bib number for school/collage marathon
		if($isMvpStudent=="1"){
			//Set logic for MVP student
			$where = "branchID='".$branchID."' AND isMvpStudent = 1 AND tournamentID='".$tournamentID."' AND status = 1";
			$maxBib = getMaxBibNo($where);
			$BranchBib = getBranchBibNo($branchID);//Get branch bib numbers
			$tFieldAry = getFieldArray();
			$fromBibNo = $tFieldAry[$tournamentID][0];
			$toBibNo = $tFieldAry[$tournamentID][1];
			if($BranchBib[$toBibNo]>$maxBib){
					$bibNo = $maxBib==0?$BranchBib[$fromBibNo]:$maxBib+1;
			}else{
					$bibNo = "FULL";//return full for registration full
			}
		}else{
			// Set logic for non mvp participants bib number
			$whr = "tournamentID = '".$tournamentID."' AND isMvpStudent=2 AND status=1";
			$maxBib = getMaxBibNo($whr);
			//echo "asdasd==".$BIBARRAY[$tournamentID]['to'];
			//echo "maxBib==$maxBib";die;
			if($BIBARRAY[$tournamentID]['to']>$maxBib){
				$bibNo = $maxBib==0?$BIBARRAY[$tournamentID]['from']:$maxBib+1;
			}else{
				if($SUBBIBARRAY[$tournamentID]['to']>$maxBib && $tournamentID=="2"){
					$bibNo = $maxBib==9000?$SUBBIBARRAY[$tournamentID]['from']:$maxBib+1;
				}else{
					$bibNo = "FULL";
				}
			}
		}
	}
	return $bibNo;
}

function getTournamentPrice($tournamentID=0){
	global $DB;
	$price = 0;
	$sql = "SELECT feeAmount FROM `".$DB->pre."tournament` WHERE tournamentID=$tournamentID";
	$DB->dbRow($sql);
	if($DB->numRows>0){
		$price = $DB->row['feeAmount'];
	}
	return $price;
}


function checkDublicate($emailID="",$mobileNo="",$pID=0){
	global $DB;
	$str = true;
	$where = "";
	if($pID>0){
		$where = " AND pID!='$pID'";
	}
	$sql = "SELECT pID FROM `".$DB->pre."participants`
			WHERE (mobileNo='".mysql_escape_string($mobileNo)."') AND status=1 $where";
	$DB->dbRow($sql);
	if($DB->numRows>0){
		$str = false;
	}		
	return $str;
}

function getBranchList(){
	global $DB; $data = array();
	$sql = "SELECT * FROM ".$DB->pre."branch_list WHERE status=1 ORDER BY collegeSchoolName ASC";
	$DB->dbRows($sql);
	if($DB->rows>0){
		foreach($DB->rows as $d){
			$data[$d['branchID']] = trim($d['collegeSchoolName']).", ".trim($d['cityVillage']).", ".trim($d['taluka']);
		}	
	}
	return $data;
}

?>