<?php
define('CHECKSUM_KEY','axis');
define('ENCRYPTION_KEY','axisbank12345678');
class AesForJava {

    const M_CBC = 'cbc';
    const M_CFB = 'cfb';
    const M_ECB = 'ecb';
    const M_NOFB = 'nofb';
    const M_OFB = 'ofb';
    const M_STREAM = 'stream';

    protected $key;
    protected $cipher;
    protected $data;
    protected $mode;
	protected $IV;

    /**
     * 
     * @param type $data
     * @param type $key
     * @param type $blockSize
     * @param type $mode
     */
    function __construct($data = null, $key = null, $blockSize = null, $mode = null) {
        $this->setData($data);
        $this->setKey($key);
        $this->setBlockSize($blockSize);
        $this->setMode($mode);
		$this->setIV("");
    }

    /**
     * 
     * @param type $data
     */
    public function setData($data) {
        $this->data = $data;
    }

    /**
     * 
     * @param type $key
     */
    public function setKey($key) {
        $this->key = $key;
    }

    /**
     * 
     * @param type $blockSize
     */
    public function setBlockSize($blockSize) {
        switch ($blockSize) {
            case 128:
                $this->cipher = MCRYPT_RIJNDAEL_128;
                break;

            case 192:
                $this->cipher = MCRYPT_RIJNDAEL_192;
                break;

            case 256:
                $this->cipher = MCRYPT_RIJNDAEL_256;
                break;
        }
    }

    /**
     * 
     * @param type $mode
     */
    public function setMode($mode) {
        switch ($mode) {
            case AesForJava::M_CBC:
                $this->mode = MCRYPT_MODE_CBC;
                break;
            case AesForJava::M_CFB:
                $this->mode = MCRYPT_MODE_CFB;
                break;
            case AesForJava::M_ECB:
                $this->mode = MCRYPT_MODE_ECB;
                break;
            case AesForJava::M_NOFB:
                $this->mode = MCRYPT_MODE_NOFB;
                break;
            case AesForJava::M_OFB:
                $this->mode = MCRYPT_MODE_OFB;
                break;
            case AesForJava::M_STREAM:
                $this->mode = MCRYPT_MODE_STREAM;
                break;
            default:
                $this->mode = MCRYPT_MODE_ECB;
                break;
        }
    }

    /**
     * 
     * @return boolean
     */
    public function validateParams() {
        if ($this->data != null &&
                $this->key != null &&
                $this->cipher != null) {
            return true;
        } else {
            return FALSE;
        }
    }
	
	 public function setIV($IV) {
		$this->IV = $IV;
	}

     protected function getIV() {
	if ($this->IV == "") {
		$this->IV = mcrypt_create_iv(mcrypt_get_iv_size($this->cipher, $this->mode), MCRYPT_RAND);
	}
		return $this->IV;
	}

    /**
     * @return type
     * @throws Exception
     */
    public function encrypt($data = null, $key = null, $blockSize = null, $mode = null) {
		$this->setData($data);
        $this->setKey($key);
        $this->setBlockSize($blockSize);
        $this->setMode($mode);
		$this->setIV("");
		
//        $padded_data = $this->pkcs5_pad($this->data);
        if ($this->validateParams()) {
            return trim(base64_encode(
                            mcrypt_encrypt(
                                    $this->cipher, $this->key, $this->pkcs5_pad($this->data), $this->mode, $this->getIV())));
        } else {
            throw new Exception('Invlid params!');
        }
    }

    /**
     * 
     * @return type
     * @throws Exception
     */
    public function decrypt($data = null, $key = null, $blockSize = null, $mode = null) {
//        echo $data;
        $this->setData(trim($data));
//        echo "<br/>".$this->data; exit;
//        $this->setData($data);
        $this->setKey($key);
        $this->setBlockSize($blockSize);
        $this->setMode($mode);
		$this->setIV("");
        
        
        
		if ($this->validateParams()) {
           //echo base64_decode($this->data); exit; 
           $depcryptedStr = trim(mcrypt_decrypt($this->cipher, $this->key, base64_decode($this->data), $this->mode, $this->getIV()));

           $unpaddedStr =  $this->pkcs5_unpad(utf8_encode($depcryptedStr));
		//$unpaddedStr =  $this->pkcs5_unpad(utf8_encode(trim(mcrypt_decrypt(
                  //          $this->cipher, $this->key, base64_decode($this->data), $this->mode, $this->getIV()))));
			if ($unpaddedStr) {
				return $unpaddedStr;
			}
			else {
				return $depcryptedStr;
			}
        } else {
            throw new Exception('Invlid params!');
        }
    }
    
    function pkcs5_pad ($text, $blocksize=16){ 
        $pad = $blocksize - (strlen($text) % $blocksize); 
        return $text . str_repeat(chr($pad), $pad); 
    } 

    function pkcs5_unpad ($text) { 
        $pad = ord($text{strlen($text)-1});
        if ($pad > strlen($text)) {
            return false; 
        }

        if (strspn($text, chr($pad), strlen($text) - $pad) != $pad) {
            return false;
        }
        return substr($text, 0, -1 * $pad);

    }   

}

//function actionInput() {
$aesJava = new AesForJava();
	if (!empty($_POST['CID']) && !empty($_POST['RID']) && !empty($_POST['CRN']) && !empty($_POST['AMT']) && !empty($_POST['VER']) && !empty($_POST['TYP']) && !empty($_POST['CNY']) && !empty($_POST['RTU']) && !empty($_POST['PPI'])) {
		$paramArr = array();
		foreach ($_POST as $key => $val) {
			if ($key != "easyTkn") {
				$paramArr[] = $key . "=" . $val;
			}
		}
	} else {
        //$digits = 5;
        //$min = pow(10, $digits - 1);
        //$max = pow(10, $digits) - 1;
        $RID = mt_rand(100000, 999999);
		$paramArr = array(
			"CID=2715",
			"RID=".$RID,
			"CRN=".$RID,
			"AMT=10.00",
			"VER=1.0",
			"TYP=test",
			"CNY=INR",
			"RTU=http://nashikmvpmarathon.org/axis.php",
			"PPI=215.00|asd|test|05/12/2015|1234567890|sadsd@acc.om|1",
			"RE1=MN",
			"RE2=",
			"RE3=",
			"RE4=",
			"RE5=",
		);
	}
	$chksm = "";
	for ($i = 0; $i < 4; $i++) {
		$valarr = explode("=", $paramArr[$i]);
		$chksm .= $valarr[1];
	}
	
	/*all post variables with thier values stored in $paramArray variable*/
	/* all post values concatenated in $chksm variable */
	/* hash() function creates hash of post values and key by using sha256 algorithm */
	
	$paramArr[] = "CKS=".hash("sha256", $chksm.CHECKSUM_KEY);
	$i = $aesJava->encrypt(implode("&", $paramArr), ENCRYPTION_KEY, 128);
	//$this->render("sampleForm", array('data' => $i, 'action' => 'payment'));
//}
//actionInput();
    $rs = "3BJFdFbGeQ2iun5DGssWeZhA7yFqr/ruoaAwEXHWb2KdEnJnPSu+r5uMUdVEFeOqOnUYdIWu0l6BwaZHz4B35kr8VFVTdMNbxwOLQxu6sDZpiDZH7tkfllOxfhUH/9kCthuyK/msjKqxdRwRWBYHw+vbt2MPLRoIqALX0YQzQzXrgumSO08lxI/N4e1lYRlceCYWyWugxM2kI/AendF7cLku9Borug7YRqkgWbO4Gfsm7zCwGaHQ2zNo6axQyGCYTgY0hT7FtgOdtBgKyLKJIA==";
    $i = "3aQqo9QX4GhARjBgeCYSY5Gjil8yPyM25PqsgBj7M73v1d5M1VhCY1rSL8R3NBFQtjPevGbZQSSDh6IAWmeVVaGhU7ZWZqT+YtwqAPEGJ3O2dnqAxo7j5S9zcx1SgH8jqji/GPy8DCC038/+UrvIZawbsU2Esx8rEa4ZNwtjrlOIOiYXdSVK94KK1UZELao71YfOJT1LPHVZWlDQq0cnAlwQPOi8EFe30dmsssb+NZkB6Ht6S80+LQTLXIprBOZIVCnemGV16CZP2Nhek/eKr/44TWv9Gr0pSzqThp/EjKQTo5meBAu0fxOwZn5JXjcmXKbI7zg+iu/lDpF1oGM0ykal9O0sbQm4lx/zbxOeHgKYN6dbu3+DZ0DjyUA5yBxP6O1NyaxdJK5ORTbIcF4j8g==";
    $rs = $i;
    $rsdesc = $aesJava->decrypt($rs, ENCRYPTION_KEY, 128);
    $decryptValues = explode("&", $rsdesc);
    //echo "<pre>";print_r($rsdata);die;
    $tranArray = array();
    //echo "<pre>decryptValues";print_r($decryptValues);
    foreach($decryptValues as $D){
        if($D){
            $expArray = explode("=",$D);
            $tranArray[$expArray[0]] = $expArray[1];
        }
    }
    //echo "<pre>";print_r($tranArray);die;
    $i = "3aQqo9QX4GhARjBgeCYSY5Gjil8yPyM25PqsgBj7M73v1d5M1VhCY1rSL8R3NBFQtjPevGbZQSSDh6IAWmeVVaGhU7ZWZqT+YtwqAPEGJ3O2dnqAxo7j5S9zcx1SgH8jqji/GPy8DCC038/+UrvIZawbsU2Esx8rEa4ZNwtjrlOIOiYXdSVK94KK1UZELao71YfOJT1LPHVZWlDQq0cnAlwQPOi8EFe30dmsssb+NZkB6Ht6S80+LQTLXIprBOZIVCnemGV16CZP2Nhek/eKr/44TWv9Gr0pSzqThp/EjKQTo5meBAu0fxOwZn5JXjcmXKbI7zg+iu/lDpF1oGM0ykal9O0sbQm4lx/zbxOeHgKYN6dbu3+DZ0DjyUA5yBxP6O1NyaxdJK5ORTbIcF4j8g==";
?>
<form method="post" name="redirect" action="https://uat-etendering.axisbank.co.in/index.php/api/payment"> 
<?php
echo "<input type=hidden name='i' value='".$i."'>";
?>
</form>
</center>
<script language='javascript'>document.redirect.submit();</script>
